# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 4
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B_MR4_strategy.txt
# LLM Suggested Fallback: Not Provided

def serendipitous_ally(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not opp_history:
        return "C"
    
    total_rounds = len(my_history) + 1
    last_opp_move = opp_history[-1]
    
    always_c = "always cooperate" in opponent_program_code.lower() or "return 'C'" in opponent_program_code.lower()
    always_d = "always defect" in opponent_program_code.lower() or "return 'D'" in opponent_program_code.lower()
    
    if always_c:
        return "D" if total_rounds > 1 else "C"
    if always_d:
        return "D"
    
    if total_rounds <= 3:
        return "C"
    elif total_rounds <= 7:
        if opp_history.count("C") >= 2:
            return "C"
        else:
            return last_opp_move
    else:
        if opp_history.count("D") > opp_history.count("C"):
            return "D"
        else:
            return "C"